# -*- coding: iso-8859-15 -*-
import time

class XdemDomainImportBase(object):
   pass

class XdemDomainExportBase(object):
   """
   xDem ist eine allgemeine Spezifikation zum schreiben und lesen von Dateninhalten.

   Dieses Klasse exportier den Inhalt einer Datenbanktabelle basierend auf einer Domain.

   """
   domain         = None
   exFile         = None
   fieldDelimeter = '\t'
   dbflds         = []
   domainFields   = []
   excludeFields  = []
   where          = None
   orderby        = None

   def __init__ (self,domain=None,exFile=None):
      self.domain = domain
      self.exFile = exFile
      pass

   def __del__ (self):
       self.exFile.close()

   def getData (self):
      """
      Datenbankstrom auf Daeten
      """
      for domain in self.domain.eachDomain(where=self.where,orderby=self.orderby):
         yield (domain)

   def writeHeader (self):
      print>>self.exFile,"IFN{0}xDEMDomain".format(self.fieldDelimeter)
      print>>self.exFile,"REM{0}Date{0}{1}".format(self.fieldDelimeter,time.strftime('%Y-%m-%dT%H:%M'))
      print>>self.exFile,"REM{0}excluded fields {1}".format(self.fieldDelimeter,', '.join(self.excludeFields))
      print>>self.exFile,"REM{0}dbtype{0}{1}".format(self.fieldDelimeter,self.domain.db.dbtype)
      print>>self.exFile,"PRG{0}table{0}{1}".format(self.fieldDelimeter,self.domain.meta['tablename'])
      print>>self.exFile,"PRG{0}domain{0}{1}".format(self.fieldDelimeter,self.domain.__class__)
      for fld in self.domain.meta['fields'].keys():
         if not fld in self.excludeFields:
            dbfld = self.domain.getDbFieldName(str(fld))
            self.dbflds.append(dbfld)
            self.domainFields.append(fld)

      print>>self.exFile,"COL"+self.fieldDelimeter+self.fieldDelimeter.join(self.dbflds)
      print>>self.exFile,"REM"+self.fieldDelimeter+self.fieldDelimeter.join(self.domainFields)

   def export (self):
      """
      Exportroutine

      HINT:
         Fuer jedes gelesenen Feld wird onField aufgerufen

      """
      self.writeHeader()
      cnt=0
      for row in self.getData():
         values = []
         for fld in self.domainFields:
            value = self.onField(fld,self.domain.getValue(fld))
            if value == None:
               value = ''
            else:
               value = str(value)
               value = value.replace('\r','')
               value = value.replace('\n',r'\n')
               value = value.replace('\t',r'\t')
            if not fld in self.excludeFields:
               values.append(value)
         cnt+=1
         print>>self.exFile,"ETR"+self.fieldDelimeter+self.fieldDelimeter.join(values)
      print>>self.exFile,"REM"+self.fieldDelimeter+"{0} Records".format(cnt)

   def onField (self,fld,value):
      """
      Wird bei jedem Feld aufgerufen
      @param   fld         Feldname (Datenbank)
      @param   value       Wert des gelesenen Feldes

      @return  ggf. veraenderter Wert des Feldes
      """
      return value

   def close(self):
      self.__del__()

   def getFileHandle (self):
      return self.exFile

class xdemDomainImport(XdemDomainImportBase):
   pass

class XdemDomainExport(XdemDomainExportBase):

   def onField(self,fld,value):
      if fld == 'LastName':
         if value != None: value = value.upper()
      return value


if __name__ == '__main__':
   import sys
   import os
   cwd = os.getcwd()

   sys.path.extend(['.','../../','../../mvc','../../../WEB-INF/mframe'])
   from dbaccess.core import *
   db = Database('sqlite',cwd+'/../../datastore/database/database.db3')
   from domain.employeesdomain import EmployeesDomain
   employees = EmployeesDomain(db)

   xdem = XdemDomainExport(employees,open('employees.xdem','wb'))

   #xdem.where = "LastName = 'King'"
   xdem.orderby = 'FirstName'
   xdem.excludeFields = ['Photo']
   xdem.export()
   f = xdem.getFileHandle()
   xdem.close()