# -*- coding: iso-8859-15 -*-
"""
Diese Klasse ist die Hauptsteuerroutine des Frameworks.

Sie steuert das gesamte Verhalten.
Es werden die Subklassen instanziert

"""
import cgi
import os
import sys
import traceback

from conf.menu import Menu
from conf.config import Config
from conf.authen import Authen
from conf.sidebox import Sidebox
from templateengine import TemplateEngine
from dbaccess.core import *
from session import Session
from version import Version


# ### Hauptklasse des Frameworks
#
class Mframe:
   form=None                                    # aktuelle Form (gesetzt aus CGI)
   webini=None                                  # Pfad auf Standard Hilfsverzeichnis WEB-INF
   menu=None                                    # Menu Objekt
   homeurl='start.py'                           # HOME URL
   path=None                                    # Aktueller Pfad gesetzt aus der CGI Variabel path
   db=None                                      # Databasehandle
   session=None                                 # Session Objekt
   authen=None                                  # Autentifizierungsmodul
   container=Config.defaulttemplate             # Standard Template aus Config
   tplateengine = TemplateEngine()              # Erzeugen der Template Engine
   flash=''                                     # Meldungszeile
   useAuthen = True                             # Flag zur Benutzung der Autentifizierung
   sidebox = None                               # Sideboxbearbeitung
   config = None                                # Konfigurationsobjekt
   showSideboxes = False                        # True wenn Sideboxes angezeigt werden sollen
   sideboxes = ''                               # Container haelt Sideboxes HTML Snippet
   version = None                               # Versionsinformationen
   mframeversion = None                         # Versionsnummer von mFrame
   logintemplate=Config.defaultlogintemplate    # Standard Logintemplate
   templateparam = {}                           # Dictionary fuer Template

   defaultMimeHeader = "Content-Type: text/html"

   # ### CGI Parameter
   # Liefert den Ihalt eines CGI Parameters
   #
   def cgiparam(self,name=None,nvl='',noneifnotused=False):
      """
      Liefert aus dem CGI einen benannten Parameter

      @param   name     Name des Cgiparmeters
      @param   nvl      NullValue wird geliefert,
                        wenn der Parameter nicht uebergeben wurde
      """

      # wenn Parameter nicht definiert
      # null-value zurueckgeben
      if name not in self.form:
         if noneifnotused:
            return None
         else:
            return nvl

      value = self.form.getvalue(name)
      if value == None:
         value = nvl
      else:
         if isinstance(value,list):
            try:
               value = value[0]
            except: value = nvl

      return value

   def __init__(self,webini='../../WEB-INF',sessionlifetime=180):

      #*# print self.defaultMimeHeader
      # Form inhalte holen
      self.form=cgi.FieldStorage(keep_blank_values=1)
      # lese path aus CGI
      self.path = self.cgiparam(name='path',nvl='/')
      self.config = Config()

      # Konfiguration
      self.homeurl=self.config.homeurl
      self.webini=webini
      self.menu=Menu()
      self.menu.path = self.path
      self.menu.homeurl=self.homeurl
      self.configMenu()
      self.sidebox = Sidebox()
      self.session = Session(sessionlifetime=sessionlifetime)
      self.mframeversion = Version().VERSION
      self.version = '0.1-E001'
      # Verbinden mit Datenbank
      # Wenn dbfilename angegeben
      if self.config.dbtype == 'sqlite':
         if self.config.sqlitefilename != None:
           self.db = Database('sqlite',Config.sqlitefilename)
         else: pass
      elif self.config.dbtype == 'mysql':
         mysqlConn = self.config.mysql
         self.db = Database('mysql',mysqlConn['host'],mysqlConn['port'],mysqlConn['username'],mysqlConn['password'],mysqlConn['schema'])
      elif self.config.dbtype == 'oracle':
         try:
            ocrConn = self.config.oracle
         except:
            raise ValueError, "Es wurden keine ORACLE Verbindungsparameter in config deklariert (oracle : {...})"
         self.db = Database('oracle',
                            ocrConn['username'],
                            ocrConn['password'],
                            ocrConn['sid'],
                            ocrConn['host'],
                            ocrConn['port'])

      self.authen = Authen(session=self.session,db=self.db)
      self.menu.authen = self.authen

      # heder abschliessen
      # Standard Mime-Header ausgeben
      #*#print self.defaultMimeHeader
      #*#self.session.setCookie()
      #*#print

   def setContainer(self,name=None):
      """
      Setzt den zu verwendenden Container.
      Ein Container befindet sich normalerweise als Datei
      in ./WEB-INF/temlate und stellt den aeusseren Rahmen
      in HTML dar. Er enhaelt Platzhalter in denen die Werte
      aus dem Framework eingetragen werden.

      @param   name        Name des Containerfiles

      """
      self.tplateengine.tplFileName = name

   def setAttribute(self,name=None,value=None):
      """
      Setzt ein Attribut in der Session.

      @param   name        Name des Attributes
      @param   value       Wert des Attributes

      """
      self.session.setAttribute(name,value)

   def getAttribute(self,name=None):
      """
      Liefert den Wert eines Attributes oder None
      wenn dieses nicht gefunden wurde aus der Session.

      @param      name        Attrbutname

      @return     Attributwert
      """
      return self.session.getAttribute(name)


   # depricated
   def start_html(self):
      print "<html><body>"

   # depricated
   def end_html(self):
      print "</body></html>"


   def setEntryDisplay(self,path=None,mode=True):
      """
      Setzte den Displaystatus

      @param   path        Patheintrag
      @param   mode        True/False (Vorgabewert True
      """
      self.menu.setDisplay(path,mode)

   def setEntryParam(self,path=None,param=[]):
      """
      Setzte zusaetzliche Parameter in Entry

      @param   path        Patheintrag
      @param   param       Zusaetzliche Parameter als Liste
      """
      self.menu.setParam(path,param)


   def addEntry(self,
               path='/',
               controller=None,
               text=None,
               addparam=None
               ):

      """
      Fuegt in die Menueeintraege einen Eintrag dynamisch hinzu

      @param   path        Der Path unter dem der Eintrag eingetragen
                           werden soll
      @param   controller  Controller Name
                           Beginnt der Controller name mit "@url:"
                           wird ein Link mit dem Inhalt nach @url: erzeugt
      @param   text        Anzeigetext (darf nicht leer sein da sonst keine
                           Anzeige erfogt.

      @param   addparam    eine Liste mit Parameter, welche dem
                           Link hinzugefuegt werden. z.B. ['action=list-edit']
      """

      myPath = path
      if myPath == '@current':
         myPath = self.path

      if not myPath.endswith ('/'): myPath = myPath + '/'
      aux = {}
      aux['text']=text
      aux['path']=myPath
      if controller != None: aux['controller']=controller
      if addparam != None:
         aux['addparam'] = addparam
      else:
         aux['addparam'] = []

      self.menu.addentries.append(aux)

   def configMenu(self,container=None,entry=None):
      """
      Liefert ein gerendetes Menue

      Konfigurieren des Menues:
       @param container      Ein Container in dem die Menueeintraege
                             eingefuegt werden
                             Beispiel: '<ul>{0}</ul>'
       @param entry          Ein Format fuer einen Menueeintrag
                             'Beispiel: <a href={0}?path={1}>{2}</a><br />'
                             Parameter:
                                0   URL
                                1   aktueller Pfad
                                2   Anzeigetext

      """

      if container == None:
         container = '<ul class="menu">\n%(entry)s</ul>\n'

      self.menu.tplMenuContainer   = container
      if entry != None:
         self.menu.tplMenuEntry       = entry

   def reload(self,path):
      """"
      Liefert einen http-equiv Fuer in Browserreload

      @param   path        Pfadeintrag
      @return  gerenderte Eintrag
      """
      retval = '<meta http-equiv="refresh" content="0;url="">' % {'url':path}
      return retval

   def redirect(self,path,other=None):
      """
      Liefert einen Redirect mittels Statuscode 303 (moved permantly)

      HINT:
         gibt immer False zurueck um einfacher in einem Controller
         verwendet werden zu koennen.

      @param   path        Pfad
      @param   other       weiter CGI Parameter (optional)
      """

      moreparam = '&'+other if other != None  else ''

      print "Refresh: 0; url={0}?path={1}{2}".format(self.config.homeurl,path,moreparam)
      return True


   def init(self):
      """
      Initaialsierungsroutine des Frameworks

      HINT:
         Prueft ob der Benutzer eingelogt ist
         Ist dies nicht der Fall, wird die Einloggmaske verwendet

      """
      if self.useAuthen:
         # Ist noch niemand angemeldet
         if not self.authen.isAuthenticated():
            self.setContainer(name=self.logintemplate)
            self.tplateengine.readTemplateFile()

   def appException(self,controllerfilename,message):
       """
       Ausgabe der Standard Fehlermeldung

       @param  controllerfilename      Name des Controllers
       @param  message                 Nachrichtentext
       """
       return """Content-Type: text/html\n\n
                 <html><body>
                 <div style="border:2px solid red;font-family:Tahoma,sans-serif;padding:16px;">
                 <h1 style="background-color:red;color:white;margin:0;font-size:1em;">Hoppla...</h1>
                 <p>
                 In der Anwendung ist ein unerwartetes Ereignis aufgetreten
                 </p>
                 <p>
                 Controller: <strong>%(filename)s</strong><br />
                 </p>
                 <p>
                 Meldung:
                 <strong>%(meldung)s</strong>
                 </p>
                 <p>
                 Bitte senden sie diese Meldung an den Anwendungsgentwickler
                 </p>
                </div>
                </body></html>
                """ % {
                   'filename':controllerfilename,
                   'meldung':message
                   }

   # Setzten des Flashparameters
   def setFlash(self,msg):
      """
      Setzen des Nachrichtentextes auf der Maske

      @param   msg         Nachrichtentext
      """
      self.flash = msg

   def run(self):
      """
      Starten des Frameworks

      Setzt die delegierten Klassen und ruft den
      Controller auf, welcher in der CGI Variabe path
      enthalten ist.
      Der Rueckgabewert des Controllers wird in das
      Template integriert.
      Der gesamte HTML Text wird an den Browser gesendet.

      """


      menu=self.menu.navigation()
      backlink=self.menu.backlink()
      controllerfilename=self.menu.getControllerPath()
      hasError = False

      content = ''
      controller = None
      try:
         controller = self.menu.getController()
      except Exception, e:
         return self.appException(controllerfilename,str(e.message))

      self.main = self

      user = self.getAttribute('user')
      if user == None:
         user = ''

      if controller != None:
         # Controller initialisieren
         #
         controller.db                    = self.db
         controller.addEntry              = self.addEntry
         controller.setEntryDisplay       = self.setEntryDisplay
         controller.setEntryParam         = self.setEntryParam
         controller.main                  = self
         controller.cgiparam              = self.cgiparam
         controller.flash                 = self.setFlash
         controller.menu                  = self.menu
         controller.path                  = self.path
         try:
            content = controller.get()
         except Exception, e:
            return self.appException(controllerfilename,str(e.message))

         if content == None:
            content = controller.html
         elif content == True:
            content = controller.html
         else:
            return ''


         menu=self.menu.navigation()
         backlink=self.menu.backlink()

         if self.showSideboxes:
            self.sideboxes=self.sidebox.get()

         if self.flash == '':
            if self.cgiparam(name='flash',nvl='') != '':
               self.flash = self.cgiparam(name='flash',nvl='')

      stylesheet=self.config.stylesheet
      javascript=self.config.javascript

      theContent = self.defaultMimeHeader+'\n'+str(self.session.cookie)+'\n\n'

      # Nur flash bauen wenn vorhanden.
      tmpFlash = '' if self.flash == '' else Config.templateFlash % {'flash':self.flash}

      self.templateparam['stylesheet']=stylesheet
      self.templateparam['javascript']=javascript
      self.templateparam['body']= content
      self.templateparam['menu']=menu
      self.templateparam['flash']=tmpFlash
      self.templateparam['backlink']=backlink
      self.templateparam['sid']=self.session.getSID()
      self.templateparam['user']=user
      self.templateparam['sideboxes']=self.sideboxes
      self.templateparam['version']=self.version
      self.templateparam['mframeversion']=self.mframeversion
      self.templateparam['rights']=self.session.getAttribute(name='rights')


      self.tplateengine.readTemplateFile()
      theContent += self.tplateengine.get(self.templateparam)
      return theContent
